<?php
/*--------------------------------------------------------------
   WidgetDefinitions.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections;

use ArrayIterator;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Type;
use InvalidArgumentException;
use IteratorAggregate;

class WidgetDefinitions implements IteratorAggregate
{
    /**
     * @var WidgetDefinition[]
     */
    private $values;
    
    
    /**
     * Constructor.
     */
    private function __construct(array $values)
    {
        $this->values = $values;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(WidgetDefinition ...$widgetDefinitions): self
    {
        return new self($widgetDefinitions);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator()
    {
        return new ArrayIterator($this->values);
    }
    
    
    /**
     * Return widget definition by type.
     */
    public function getByType(Type $type): WidgetDefinition
    {
        /**
         * @var WidgetDefinition $widgetDefinition
         */
        foreach ($this->values as $widgetDefinition) {
            if ($type->value() === $widgetDefinition->type()->value()) {
                return $widgetDefinition;
            }
        }
        
        throw new InvalidArgumentException("Widget definition not found");
    }
}